<?php
require_once 'functions.php';

// Khóa tránh cron chạy song song
$lock = fopen(__DIR__ . '/lockfile.txt', 'w+');
if (!flock($lock, LOCK_EX | LOCK_NB)) {
    exit("⏳ Script đang chạy, bỏ qua...\n");
}

$data = json_decode(file_get_contents('data.json'), true);
if (!$data) exit("Không có dữ liệu UID để kiểm tra.\n");

foreach ($data as $index => &$uid) {
    $newStatus = checkUIDStatus($uid['uid']);

    // ✅ Chỉ khi trạng thái thay đổi (die ↔ live)
    if ($newStatus !== $uid['status'] && in_array($newStatus, ['live', 'dead'])) {

        $uid['last_check'] = date('H:i:s - d/m/Y');
        $oldStatus = $uid['status'];
        $uid['status'] = $newStatus;

        $photoUrl = "https://graph.facebook.com/{$uid['uid']}/picture?type=large";
        $profileLink = "<a href=\"https://facebook.com/{$uid['uid']}\">{$uid['uid']}</a>";
        $name = $uid['name'] ?: "Không tên";
        $note = $uid['note'] ?: "Không có";
        $chat_id = $uid['chat_id'];

        // Nội dung caption
        if ($newStatus === 'live') {
            $caption  = "✅ UID $profileLink → <b>Mở khóa thành công</b>\n\n";
            $caption .= "👤 Tên khách: $name\n";
            $caption .= "📝 Ghi chú: $note\n";
            $caption .= "📌 Bắt đầu kiểm tra: {$uid['added_at']}\n";
            $caption .= "⏰ Mở khóa lúc: {$uid['last_check']}";
        } else {
            $caption  = "☠️ UID $profileLink → <b>Die</b>\n\n";
            $caption .= "👤 Tên khách: $name\n";
            $caption .= "📝 Ghi chú: $note\n";
            $caption .= "📌 Bắt đầu kiểm tra: {$uid['added_at']}\n";
            $caption .= "⏰ Phát hiện die: {$uid['last_check']}";
        }

        $keyboard = [
            "inline_keyboard" => [
                [
                    ["text" => "✅ Tiếp tục theo dõi", "callback_data" => "keep_{$uid['uid']}"],
                    ["text" => "❌ Dừng theo dõi", "callback_data" => "remove_{$uid['uid']}"]
                ]
            ]
        ];

        // Gửi ảnh kèm caption
        sendPhotoWithKeyboard($chat_id, $photoUrl, $caption, $keyboard);

        // ✅ Lưu ngay lập tức thay đổi này
        file_put_contents('data.json', json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));

        // nghỉ 0.3s để tránh spam
        usleep(300000);
    }
}

// ✅ Giải phóng khóa
flock($lock, LOCK_UN);
fclose($lock);
?>
